% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.mspct.R
\name{join_mspct}
\alias{join_mspct}
\alias{join_mspct.default}
\alias{join_mspct.generic_mspct}
\alias{join_mspct.source_mspct}
\alias{join_mspct.response_mspct}
\alias{join_mspct.filter_mspct}
\alias{join_mspct.reflector_mspct}
\alias{join_mspct.object_mspct}
\title{Join all spectra in a collection}
\usage{
join_mspct(x, type, ...)

\method{join_mspct}{default}(x, type = "full", ...)

\method{join_mspct}{generic_mspct}(x, type = "full", col.name, ...)

\method{join_mspct}{source_mspct}(x, type = "full", unit.out = "energy",
  ...)

\method{join_mspct}{response_mspct}(x, type = "full", unit.out = "energy",
  ...)

\method{join_mspct}{filter_mspct}(x, type = "full",
  qty.out = "transmittance", ...)

\method{join_mspct}{reflector_mspct}(x, type = "full", ...)

\method{join_mspct}{object_mspct}(x, type = "full", qty.out, ...)
}
\arguments{
\item{x}{A generic_mspct object, or an object of a class derived from
generic_mspct.}

\item{type}{character Type of join: "left", "right", "inner" or "full"
(default). See details for more information.}

\item{...}{ignored (possibly used by derived methods).}

\item{col.name}{character, name of the column in the spectra to be preserved,
in addition to "w.length".}

\item{unit.out}{character Allowed values "energy", and "photon", or its alias
"quantum".}

\item{qty.out}{character Allowed values "transmittance", and "absorbance".}
}
\value{
An object of class dataframe, with the spectra joined by wave length,
  with rows in addition sorted by wave length (variable \code{w.length}).
}
\description{
Join all the spectra contained in a homogenous collection, returning a data
frame with spectral-data columns named according to the names of the spectra
in the collection. By default a full join is done, filling the spectral
data for missing wave lengths in individual spectra with \code{NA}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: 

\item \code{generic_mspct}: 

\item \code{source_mspct}: 

\item \code{response_mspct}: 

\item \code{filter_mspct}: 

\item \code{reflector_mspct}: 

\item \code{object_mspct}: 
}}

\note{
Currently only generic_spct, source_mspct, response_mspct,
  filter_mspct, reflector_mspct and object_mspct classes have this method
  implemented.
}
\seealso{
Other conversion of collections of spectra: \code{\link{as.generic_mspct}},
  \code{\link{split2mspct}}, \code{\link{subset2mspct}}
}
