#' Total transmittance for photography filters
#'
#' Total transmittance for filters intended for use on camera lenses from
#' various suppliers: Formatt Hitech, Haida, Heliopan, Hoya, Rocolax and Zomei.
#' Data are to be used as "reference values only" as values may change in time
#' and production batch.
#'
#' The variables are as follows:
#'
#' \itemize{
#'   \item w.length (nm)
#'   \item Tfr (fraction)
#' }
#'
#' @section Supplier's web sites:
#' \url{https://www.baader-planetarium.com/en/},
#' \url{https://www.formatt-hitech.com/},
#' \url{https://www.fotga.com/},
#' \url{https://www.haidaphoto.com/en/},
#' \url{http://www.heliopan.de/},
#' \url{https://hoyafilter.com/},
#' \url{https://kenkoglobal.com/},
#' \url{https://kolarivision.com/},
#' \url{https://schneiderkreuznach.com/en/photo-optics},
#' \url{https://tiffen.com/},
#' \url{https://www.uvroptics.com/},
#' \url{https://www.zomei.com/}.
#'
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#'
#' @note Data measured with an Agilent 8453 spectrophotometer (based on diode array).
#'
#' @note Idependent measurement of a single sample, not a specification.
#'
#' @examples
#' photography_filters
#'
"photography_filters"

#' @rdname photography_filters
#'
"hoya_filters"

#' @rdname photography_filters
#'
"firecrest_filters"

#' @rdname photography_filters
#'
"haida_filters"

#' @rdname photography_filters
#'
"zomei_filters"

#' @rdname photography_filters
#'
"fake_unbranded_filters"

#' @rdname photography_filters
#'
"baader_filters"

#' @rdname photography_filters
#'
"uvroptics_filters"

#' @rdname photography_filters
#'
"tiffen_filters"

#' @rdname photography_filters
#'
"bw_filters"

#' @rdname photography_filters
#'
"heliopan_filters"

#' @rdname photography_filters
#'
"zeiss_filters"

#' @rdname photography_filters
#'
"kenko_filters"

#' @rdname photography_filters
#'
"rocolax_filters"

#' @rdname photography_filters
#'
"kolarivision_filters"

#' @rdname photography_filters
#'
"fotga_filters"
