% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-oojaz-file.r
\name{read_oo_jazirrad}
\alias{read_oo_jazirrad}
\alias{read_oo_jazpc}
\alias{read_oo_jazdata}
\title{Read Files Saved by Ocean Optics' Jaz spectrometer.}
\usage{
read_oo_jazirrad(
  file,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale()
)

read_oo_jazpc(
  file,
  qty.in = "Tpc",
  Tfr.type = c("total", "internal"),
  Rfr.type = c("total", "specular"),
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale()
)

read_oo_jazdata(
  file,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale()
)
}
\arguments{
\item{file}{character string.}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date is extracted from the
file header.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone used for interpreting times saved in the file
header.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{qty.in}{character string, one of "Tpc" (spectral transmittance, \%), "A"
(spectral absorbance), or "Rpc" (spectral reflectance, \%).}

\item{Tfr.type}{character string, either "total" or "internal".}

\item{Rfr.type}{character string, either "total" or "specular".}
}
\value{
A source_spct object, a filter_spct object, a reflector_spct object
  or a raw_spct object.
}
\description{
Reads and parses the header of processed data text files output by
Jaz instruments extracting the spectral data from the body of the file 
and the metadata, including time and date of measurement from the header.
Jaz modular spectrometers were manufactured by Ocean Optics.
The company formerly named Ocean Optics is now called Ocean Insight.
}
\details{
Function \code{read_oo_jazirrad} can read processed irradiance
output files. Function \code{read_oo_jazpc} can read processed transmittance
and reflectance output files (expressed as \%s). Function 
\code{read_oo_jazdata} can read raw-counts data.
}
\note{
Although the parameter is called \code{date} a date time is accepted 
  and expected. Time resolution is < 1 s if seconds are entered with a
  decimal fraction, such as "2021-10-05 10:10:10.1234".
}
\examples{

 file.name <- 
   system.file("extdata", "spectrum.jaz", 
               package = "photobiologyInOut", mustWork = TRUE)
                
 jaz.spct <- read_oo_jazpc(file = file.name)
 
 jaz.spct
 getWhenMeasured(jaz.spct)
 getWhatMeasured(jaz.spct)
 cat(comment(jaz.spct))

}
\references{
\url{https://www.oceaninsight.com/}
}
