#' @title Vital Technologies sensors
#'
#' @description A vector of indeces for stracting subsets of spectra from the
#' \code{\link{sensors.mspct}} object.
#'
#' @format A character vector of members of the collection of spctra.
#'
#' @docType data
#' @keywords datasets
#'
#' @details
#' Vital "Blue Wave" BW-20 UV-B "erythemal" radiometer. Data for a specific
#' unit included in a sensor intercomparison event.
#'
#' Manufacturer: Vital Technologies, Canada. Company no longer in business.
#'
#' @source
#' Data kindly made available by Lasse Ylianttila.
#'
#' @references
#' Leszczynski K, Jokela K, Ylianttila L, Visuri R, Blumthaler M. 1997. Report of the WMO/STUK Intercomparison
#' of erythemally-weighted solar UV radiometers (Spring/Summer 1995, Helsinki, Finland). WMO-GAW Report No. 112, 90 pages.
#'
#' Leszczynski K, Jokela K, Ylianttila L, Visuri R, Blumthaler M. 1998. Erythemally weighted radiometers in solar
#' UV monitoring: results from the WMO/STUK Intercomparison. Photochem. Photobiol. 67(2):212-221.
#'
#' @examples
#'
#' vitaltech_sensors
#'
"vitaltech_sensors"
