#' @title 'Berger' UV-Biometer
#'
#' @description A vector of indeces for stracting subsets of spectra from the
#' \code{\link{sensors.mspct}} object.
#'
#' @format A character vector of members of the collection of spctra.
#'
#' @docType data
#' @keywords datasets
#'
#' @note
#' 'Berger' UV-Biometer (Fig. 1 in Berger, 1994).
#' Digitized with 'enguage' from manufacturers brochures. These are approximate
#' data, both because of the digitizing process, and because they are
#' either typical values or for a particular sensor unit. Individual sensor units
#' are expected to differ to some degree in spectral response.
#'
#' @references
#' Berger, Daniel (n.d., ca. 1994) A comparison of Spectroradiometers to Radiometers for
#' UV Radiation Measurements. Solar Light Co., Inc., Philadelphia.
#'
#' @examples
#' berger_sensors
#'
"berger_sensors"
