% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen.m.q.fun.r
\name{GEN_M_q_fun}
\alias{GEN_M_q_fun}
\title{Gives values for GPAS BSWF (Micheletti's formulation) as a function of
wavelength}
\usage{
GEN_M_q_fun(w.length)
}
\arguments{
\item{w.length}{numeric array of w.length (nm)}
}
\value{
a numeric array of the same length as \code{w.length} with values for
  the BSWF normalized as in the original source.  The returned values are
  based on quantum effectiveness units.
}
\description{
This function gives a set of numeric multipliers that can be used as a weight
to calculate effective doses and irradiances. The BSWF is normalized at 300
nm.
}
\note{
In the original publication [2] describing the formulation, the
  long-end wavelength boundary is not specified, but 313.3 nm is usually
  used. The equation is coded here with the limit at 342 nm as at longer
  wavelengths the values increase with increasing wavelength. The effect on
  the RAF and doses of changing this boundary ican be substantial, and has
  been analysed by Micheletti et al. [3].
}
\examples{
GEN_M_q_fun(293:400)

}
\references{
[1]Caldwell, M. M. (1971) Solar UV irradiation and the growth and
development of higher plants. In Giese, A. C. (Ed.) Photophysiology, Academic
Press, 1971, 6, 131-177

[2] Micheletti, M. I. and R. D. Piacentini (2002) Irradiancia espetral solar
UV-B y su relación con la efectividad de daño biológico a las plantas. ANALES
AFA, 13, 242-248

[3] Micheletti, M. I.; Piacentini, R. D. & Madronich, S. (2003) Sensitivity
of Biologically Active UV Radiation to Stratospheric Ozone Changes: Effects
of Action Spectrum Shape and Wavelength Range Photochemistry and
Photobiology, 78, 456-461
}
\seealso{
Other BSWF functions: \code{\link{CH4_e_fun}},
  \code{\link{CH4_q_fun}}, \code{\link{CIE_e_fun}},
  \code{\link{CIE_q_fun}}, \code{\link{DNA_GM_q_fun}},
  \code{\link{DNA_P_q_fun}}, \code{\link{FLAV_q_fun}},
  \code{\link{GEN_G_q_fun}}, \code{\link{GEN_T_q_fun}},
  \code{\link{ICNIRP_e_fun}}, \code{\link{PG_q_fun}}
}

