% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/maxHeight.R
\name{maxHeight}
\alias{maxHeight}
\title{Maximum tree height}
\usage{
maxHeight(tree, normalise = FALSE)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{normalise}{option to normalise the result, default is \code{FALSE}.}
}
\value{
An integer giving the maximum height of tips in the tree.
}
\description{
Find the maximum height of tips in the tree.
}
\examples{
## Maximum height of tips in a random tree with 10 tips:
tree <- rtree(10)
plot(tree)
maxHeight(tree) 
maxHeight(tree, normalise=TRUE)

}
\author{
Michelle Kendall \email{michelle.louise.kendall@gmail.com}

Caroline Colijn \email{c.colijn@imperial.ac.uk}
}

