% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ladderSizes.R
\name{ladderSizes}
\alias{ladderSizes}
\title{Ladder sizes}
\usage{
ladderSizes(tree)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}
}
\value{
A list of:
\itemize{
\item ladderSizes the sizes of ladders in the tree
\item ladderNodes the ladder nodes in the tree
\item ladderEdges the edges between ladder nodes of the tree
}
}
\description{
Finds the sizes and positions of ladders in the tree. 
A ladder is here defined to be a series of consecutive nodes in the tree,
each of which has exactly one tip child (as counted by \code{\link{ILnumber}}).
The size of the ladder is given by the number of nodes in the chain.
}
\examples{
## Find ladder sizes in a random tree with 20 tips:
tree <- rtree(20)
plot(tree)
ladderSizes(tree)
# note that the ladders can be highlighted in a plot using ladderShow:
ladderShow(tree)


}
\seealso{
\code{\link{ILnumber}}, \code{\link{ladderShow}}
}
\author{
Caroline Colijn \email{c.colijn@imperial.ac.uk}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
