% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ILnumber.R
\name{ILnumber}
\alias{ILnumber}
\title{IL number}
\usage{
ILnumber(tree, normalise = FALSE)
}
\arguments{
\item{tree}{a tree of class \code{phylo} or \code{phylo4}. The tree should be binary and rooted; if not it will be coerced into a binary rooted tree using multi2di, if possible.}

\item{normalise}{option to normalise the result, default is \code{FALSE}}
}
\value{
The integer number of internal nodes with a single tip child.
}
\description{
Computes the number of internal nodes with a single tip child.
}
\examples{
## Find the IL number of a random tree with 10 tips:
tree <- rtree(10)
plot(tree)
ILnumber(tree)
## and the normalised IL number:
ILnumber(tree, normalise=TRUE)

}
\author{
Michael Boyd \email{mboyd855@gmail.com}

Michelle Kendall \email{michelle.louise.kendall@gmail.com}
}
