% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addData-methods.R
\docType{methods}
\name{addData}
\alias{addData}
\alias{addData,phylo4-method}
\alias{addData,phylo4d-method}
\alias{addData-methods}
\title{Adding data to a phylo4 or a phylo4d object}
\usage{
addData(x, ...)

\S4method{addData}{phylo4d}(x, tip.data = NULL, node.data = NULL,
  all.data = NULL, merge.data = TRUE, pos = c("after", "before"), ...)

\S4method{addData}{phylo4}(x, tip.data = NULL, node.data = NULL,
  all.data = NULL, merge.data = TRUE, pos = c("after", "before"), ...)
}
\arguments{
\item{x}{a phylo4 or a phylo4d object}

\item{tip.data}{a data frame (or object to be coerced to one)
containing only tip data}

\item{node.data}{a data frame (or object to be coerced to one)
containing only node data}

\item{all.data}{a data frame (or object to be coerced to one)
containing both tip and node data}

\item{merge.data}{if both \code{tip.data} and \code{node.data} are
provided, it determines whether columns with common names will be
merged together (default TRUE). If FALSE, columns with common
names will be preserved separately, with ".tip" and ".node"
appended to the names. This argument has no effect if
\code{tip.data} and \code{node.data} have no column names in
common.}

\item{pos}{should the new data provided be bound \code{before} or
\code{after} the pre-existing data?}

\item{\dots}{additional arguments to control how matching between
data and tree (see Details section of
\code{\link{phylo4d-methods}} for more details).}
}
\value{
\code{addData} returns a \code{phylo4d} object.
}
\description{
\code{addData} adds data to a \code{phylo4} (converting it in a
\code{phylo4d} object) or to a \code{phylo4d} object
}
\details{
Rules for matching data to tree nodes are identical to those used
by the \code{\link{phylo4d-methods}} constructor.

If any column names in the original data are the same as columns
in the new data, ".old" is appended to the former column names and
".new" is appended to the new column names.

The option \code{pos} is ignored (silently) if \code{x} is a
\code{phylo4} object. It is provided for compatibility reasons.
}
\examples{
  data(geospiza)
  nDt <- data.frame(a=rnorm(nNodes(geospiza)), b=1:nNodes(geospiza),
                    row.names=nodeId(geospiza, "internal"))
  t1 <- addData(geospiza, node.data=nDt)
}
\author{
Francois Michonneau
}
\seealso{
\code{\link{tdata}} for extracting or updating data and
\code{\link{phylo4d-methods}} constructor.
}
\keyword{methods}

