% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print_and_plot.R
\name{plot.DAG}
\alias{plot.DAG}
\title{Plot a directed acyclic graph.}
\usage{
\method{plot}{DAG}(x, labels = NULL, algorithm = "sugiyama",
  text_size = 6, box_x = 12, box_y = 8, edge_width = 1.5,
  curvature = 0.02, rotation = 0, flip_x = FALSE, flip_y = FALSE,
  arrow = grid::arrow(type = "closed", 18, grid::unit(15, "points")), ...)
}
\arguments{
\item{x}{A \code{DAG} object, usually created with the \code{DAG} function.}

\item{labels}{An optional set of labels to use for the nodes. This should be a named vector, of
the form \code{c(var1 = "label1", var2 = "label2")}.
If left at \code{NULL}, the variable names of the DAGs are used.}

\item{algorithm}{A layout algorithm from \code{igraph}, see
\code{\link[ggraph]{create_layout}} and \code{\link[ggraph]{create_layout.igraph}}. By default,
uses the Sugiyama layout algorithm, which is designed to minimize edge crossing in DAGs.}

\item{text_size}{Size of the node label text.}

\item{box_x}{To avoid the arrows colliding with the nodes, specify the
rectangular dimensions of an invisible box around each node. If you have
long labels, you need to increase this.}

\item{box_y}{To avoid the arrows colliding with the nodes, specify the
rectangular dimensions of an invisible box around each node. If you have
multi-line labels, you need to increase this.}

\item{edge_width}{Width of the edges.}

\item{curvature}{Curvature of the edges. A slight curvature can look pretty.}

\item{rotation}{Supply the degrees you want to rotate the layout by. This is useful in order to
put rotate your upstream nodes towards the top if needed.}

\item{flip_x}{Whether to flip the node positions horizontally.}

\item{flip_y}{Whether to flip the node positions vertically.}

\item{arrow}{A \code{grid::arrow} object, specifying the shape and size of the arrowheads.

The order of facets is taken from the ordering of the list, with the facet
labels coming from the names of the list. If the list is unnamed, sequential
lettering is used.}

\item{...}{Not used.}
}
\description{
Plot a directed acyclic graph.
}
\examples{
  plot(DAG(a ~ b + c + d))
}
