% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phylo_beta.R
\name{match_phylo_comm}
\alias{match_phylo_comm}
\title{Match taxa and in phylogeny and community matrix}
\usage{
match_phylo_comm(phy, comm, delete_empty_rows = TRUE)
}
\arguments{
\item{phy}{A phylogeny}

\item{comm}{A (sparse) community data matrix}

\item{delete_empty_rows}{delete rows with no observation}
}
\value{
A list containing the following elements, pruned and sorted to match one another:
\item{phy}{A phylogeny object of class phylo}
\item{comm}{A (sparse) community data matrix}
}
\description{
match_phylo_comm compares taxa (species, labels, tips) present in a phylogeny
with a community matrix. Pruning, sorting and trying to add missing species
on genus level if possible to match in subsequent analysis.
}
\details{
Based on the function of the same name in picante but allows sparse matrices
and with taxa addition.
}
\examples{
data(africa)
tree <- africa$phylo
x <- africa$comm

subphy <- match_phylo_comm(tree, x)$phy
submat <- match_phylo_comm(tree, x)$com
}
\keyword{bioregion}
