% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pie.R
\name{plot_pie}
\alias{plot_pie}
\title{Visualize biogeographic patterns using pie charts}
\usage{
plot_pie(
  omega,
  shp,
  r = 1,
  col = hcl.colors(5),
  pie_control = list(),
  legend = FALSE,
  legend_pie = FALSE,
  ...
)
}
\arguments{
\item{omega}{a matrix of phyloregion of probabilities of each species}

\item{shp}{a polygon shapefile of grid cells with a column labeled
\dQuote{grids}.}

\item{r}{Radius of the pie legend to be displayed}

\item{col}{List of colors for the pies.}

\item{pie_control}{The list of control parameters to be passed into
the add.pie function.}

\item{legend}{Logical, whether to plot a legend or not.}

\item{legend_pie}{Legend for the pie plots.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
Returns no value, just map color pies in geographic space!
}
\description{
Visualize biogeographic patterns using pie charts
}
\examples{
data(africa)
K <- ncol(africa$omega)

COLRS <- phyloregion:::hue(K)
plot_pie(africa$omega, shp = africa$polys, col=COLRS)
}
