% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evol_distinct.R
\name{evol_distinct}
\alias{evol_distinct}
\title{Species' evolutionary distinctiveness}
\usage{
evol_distinct(
  tree,
  type = c("equal.splits", "fair.proportion"),
  scale = FALSE,
  use.branch.lengths = TRUE,
  ...
)
}
\arguments{
\item{tree}{an object of class \code{phylo}.}

\item{type}{a) equal splits (Redding and Mooers 2006) or b) fair proportions
(Isaac et al., 2007)}

\item{scale}{The scale option refers to whether or not the phylogeny should
be scaled to a depth of 1 or, in the case of an ultrametric tree, scaled such
that branch lengths are relative.}

\item{use.branch.lengths}{If use.branch.lengths=FALSE, then all branch
lengths are changed to 1.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
a named vector with species scores.
}
\description{
Calculates evolutionary distinctiveness measures for a suite of species by:
a) equal splits (Redding and Mooers 2006)
b) fair proportions (Isaac et al., 2007).
This a new implementation of the picante function \code{evol.distinct}
however allowing multifurcations and can be orders of magnitude faster.
}
\examples{
tree <- ape::rcoal(10)
evol_distinct(tree)
evol_distinct(tree, type = "fair.proportion")
}
\references{
Redding, D.W. and Mooers, A.O. (2006). Incorporating evolutionary measures
into conservation prioritisation. \emph{Conservation Biology}, \strong{20},
1670--1678.

Isaac, N.J.B., Turvey, S.T., Collen, B., Waterman, C. and Baillie, J.E.M.
(2007). Mammals on the EDGE: conservation priorities based on threat and
phylogeny. \emph{PLoS ONE}, \strong{2}, e296.
}
\seealso{
\code{\link[picante]{evol.distinct}}, \code{\link{phyloregion}}
}
\author{
Klaus Schliep
}
