% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trees2matrices.R
\name{trees2matrices}
\alias{trees2matrices}
\title{Convert phylogenetic trees to distance matrices}
\usage{
trees2matrices(trees, distance = "patristic", bvalue = 0)
}
\arguments{
\item{trees}{A list of gene trees in format "multiphylo".}

\item{distance}{A method to generate distance matrices. It could be "nodal"
to establish that the distance between two species is the number of nodes
that separate them. Or "patristic" (default) if the distance between two
species is the sum of branch lengths separating them. The "nodal" option should
only be used if all species are present in all trees (no missing data).}

\item{bvalue}{This argument is only used if trees contain bootstrap values.
It determines under what bootstrap values the nodes should be collapsed.
Value 0 (the default) means that no nodes are collapsed.}
}
\value{
return a list of distance matrices
}
\description{
Transform a list of phylogenetic trees into a 
list of phylogenetic distance matrices.
}
\examples{
data(carnivora)
matrices<-trees2matrices(carnivora)
}
