#' airfoil self noise dataset
#'
#' The NASA data set comprises different size NACA 0012 airfoils at various wind tunnel speeds and angles of attack.
#' The span of the airfoil and the observer position were the same in all of the experiments.
#'
#' @docType data
#'
#' @usage data(airfoil)
#'
#' @references T.F. Brooks, D.S. Pope, and A.M. Marcolini.
#' Airfoil self-noise and prediction.
#' Technical report, NASA RP-1218, July 1989.

#' @references K. Lau.
#' A neural networks approach for aerofoil noise prediction.
#' Master's thesis, Department of Aeronautics.
#' Imperial College of Science, Technology and Medicine (London, United Kingdom), 2006.

#' @references Lopez, R. and Balsa-Canto, E. and Onate, E.
#' Neural Networks for Variational Problems in Engineering.
#' PhD Thesis, Technical University of Catalonia, 2008.
#'
#' @source \href{https://archive.ics.uci.edu/ml/datasets/Airfoil+Self-Noise#}{UCI Archive}
#'
#' @examples
#' data(airfoil)
#' airfoil$pressure
"airfoil"
