% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation_structure.R
\name{aggregation_structure}
\alias{aggregation_structure}
\alias{piar_aggregation_structure}
\title{Make a price index aggregation structure}
\usage{
aggregation_structure(x, weights = NULL)
}
\arguments{
\item{x}{A list of character vectors that give the codes/labels for each
level of the classification, ordered so that moving down the list goes down
the hierarchy. The last vector gives the elemental aggregates, which should
have no duplicates. All vectors should be the same length, without
\code{NA}s, and there should be no duplicates across different levels of
\code{x}. Names for \code{x} are used as level names; otherwise, levels are named
level1, level2, ..., ea.}

\item{weights}{A numeric vector of aggregation weights for the elemental
aggregates (i.e., the last vector in \code{x}), or something that can be coerced
into one. The default is to give each elemental aggregate the same weight.}
}
\value{
A price index aggregation structure of class \code{piar_aggregation_structure}.
This is a list-S3 class with the following components.

\item{child}{A nested list that gives the positions of the immediate
children for each node in each level of the aggregation structure above the
terminal nodes.}
\item{parent}{A list that gives the position of the
immediate parent for each node of the aggregation structure below the
initial nodes.}
\item{levels}{A named list of character vectors that give the levels of \code{x}.}
\item{weights}{A vector giving the weight for each elemental
aggregate.}
}
\description{
Create a price index aggregation structure from a hierarchical
classification and aggregation weights that can be used to aggregate
elemental indexes.
}
\section{Warning}{
 The \code{aggregation_structure()} function does its best
to check its arguments, but there should be no expectation that the result
of \code{aggregation_structure()} will make any sense if \code{x} does not
represent a nested hierarchy.
}

\examples{
# A simple aggregation structure
#            1
#      |-----+-----|
#      11          12
#  |---+---|       |
#  111     112     121
#  (1)     (3)     (4)

aggregation_weights <- data.frame(
  level1 = c("1", "1", "1"),
  level2 = c("11", "11", "12"),
  ea     = c("111", "112", "121"),
  weight = c(1, 3, 4)
)

aggregation_structure(
  aggregation_weights[1:3],
  weights = aggregation_weights[[4]]
)

# The aggregation structure can also be made by expanding the
# elemental aggregates

with(
  aggregation_weights,
  aggregation_structure(expand_classification(ea), weight)
)

}
\seealso{
\code{\link[=aggregate.piar_index]{aggregate()}} to aggregate price indexes made
with \code{\link[=elemental_index]{elemental_index()}}.

\code{\link[=expand_classification]{expand_classification()}} to make \code{x} from a character
representation of a hierarchical aggregation structure.

\code{\link[=as_aggregation_structure]{as_aggregation_structure()}} to coerce tabular data into an
aggregation structure.

\code{\link[=as.data.frame.piar_aggregation_structure]{as.data.frame()}} and
\code{\link[=as.matrix.piar_aggregation_structure]{as.matrix()}} to coerce an
aggregation structure into a tabular form.

\code{\link[=weights.piar_aggregation_structure]{weights()}} to get the
weights for an aggregation structure.

\code{\link[=update.piar_aggregation_structure]{update()}} for updating a
price index aggregation structure with an aggregated index.
}
