% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pp_cfg.R
\name{pp_cfg}
\alias{pp_cfg}
\alias{is_pp_cfg}
\alias{as_pp_cfg}
\title{Configuration list R6 object}
\usage{
pp_cfg(cfg = list())

is_pp_cfg(cfg)

as_pp_cfg(cfg = list())
}
\arguments{
\item{cfg}{List of configuration options}
}
\description{
\code{pp_cfg} and \code{as_pp_cfg} creates piecepack configuration list R6 object.
\code{is_pp_cfg} returns \code{TRUE} if object is a piecepack configuration list R6 object.
\code{as.list} will convert it into a list.
}
\examples{
 cfg <- pp_cfg(list(invert_colors=TRUE))
 as.list(cfg)
 is_pp_cfg(cfg)
 as_pp_cfg(list(suit_color="darkred,black,darkgreen,darkblue,grey"))
 cfg$get_suit_color(suit=3)
 cfg$annotation_color
 cfg$has_matchsticks
 cfg$has_matchsticks <- TRUE
 cfg$has_matchsticks
 cfg$get_width("tile_back")
 cfg$get_height("die_face")
 cfg$get_depth("coin_face")
 \donttest{
   cfg <- list()
   system.time(replicate(100, grid.piece("tile_face", 4, 4, cfg)))
   cfg <- pp_cfg(list())
   system.time(replicate(100, grid.piece("tile_face", 4, 4, cfg)))
 }
  
}
\seealso{
<https://trevorldavis.com/piecepackr/configuration-lists.html> for more details 
     about \code{piecepackr} configuration lists.
}
