% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/game_systems.R
\name{game_systems}
\alias{game_systems}
\alias{to_hexpack}
\alias{to_subpack}
\title{Standard game systems}
\usage{
game_systems(style = NULL, round = FALSE, pawn = "token")

to_hexpack(cfg = getOption("piecepackr.cfg", pp_cfg()))

to_subpack(cfg = getOption("piecepackr.cfg", pp_cfg()))
}
\arguments{
\item{style}{If \code{NULL} (the default) uses suit glyphs from the default \dQuote{sans} font.
If \code{"dejavu"} it will use suit glyphs from the "DejaVu Sans" font
(must be installed on the system).}

\item{round}{If \code{TRUE} the \dQuote{shape} of \dQuote{tiles} and \dQuote{cards}
will be \dQuote{roundrect} instead of \dQuote{rect} (the default).}

\item{pawn}{If \code{"token"} (default) the piecepack pawn will be a two-sided token in a \dQuote{halma} outline,
if \code{"peg-doll"} the piecepack pawn will be a \dQuote{peg doll} style pawn, and
if \code{"joystick"} the piecepack pawn will be a \dQuote{joystick} style pawn.
Note for the latter two pawn styles only \code{pawn_top} will work with \code{grid.piece}.}

\item{cfg}{List of configuration options}
}
\description{
\code{game_systems} returns a list of \code{pp_cfg} objects
representing several game systems and pieces.
\code{to_subpack} and \code{to_hexpack} will attempt to generate matching (piecepack stackpack)
subpack and (piecepack) hexpack \code{pp_cfg} R6 objects respectively given a piecepack configuration.
}
\details{
Contains the following game systems:\describe{
\item{alquerque}{Boards and pieces in six color schemes for Alquerque}
\item{checkers1, checkers2}{Checkers and checkered boards in six color schemes.
Checkers are represented by a piecepackr \dQuote{bit}.
The \dQuote{board} \dQuote{face} is a checkered board and the \dQuote{back} is a lined board.
Color is controlled by suit and number of rows/columns by rank.
\code{checkers1} has one inch squares and \code{checkers2} has two inch squares.}
\item{chess1, chess2}{Chess pieces, boards, and dice in six color schemes.
Chess pieces are represented by a \dQuote{bit} (face).
The \dQuote{board} \dQuote{face} is a checkered board and the \dQuote{back} is a lined board.
Color is controlled by suit and number of rows/columns by rank.
\code{chess1} has one inch squares and \code{chess2} has two inch squares.
Currently uses print-and-play style discs instead of 3D Staunton chess pieces.}
\item{dice}{Traditional six-sided pipped dice in six color schemes (color controlled by their suit).}
\item{dice_d4, dice_numeral, dice_d8, dice_d10, dice_d10_percentile, dice_d12, dice_d20}{
Polyhedral dice most commonly used to play wargames, roleplaying games, and trading card games:\describe{
\item{dice_d4}{Four-sided dice in six color schemes (color controlled by their suit).
Tetrahedrons with the rank as a numeral at the top point.}
\item{dice_numeral}{Six-sided dice with numerals instead of pips in six color schemes (color controlled by their suit).}
\item{dice_d8}{Eight-sided dice in six color schemes (color controlled by their suit).
Octahedrons with the rank as a numeral at the top face.}
\item{dice_d10}{Ten-sided dice in six color schemes (color controlled by their suit).
Pentagonal trapezohedrons with the rank as a numeral at the top face.
The rank of ten is represented by a zero.}
\item{dice_d10_percentile}{Ten-sided dice in six color schemes (color controlled by their suit).
Pentagonal trapezohedrons with the rank as a numeral followed by a zero at the top face.
The rank of ten is represented by a zero.}
\item{dice_d12}{Twelve-sided dice in six color schemes (color controlled by their suit).
Dodecahedrons with the rank as a numeral at the top face.}
\item{dice_d20}{Twenty-sided dice in six color schemes (color controlled by their suit).
Icosahedrons with the rank as a numeral at the top face.}}}
\item{dice_fudge}{\dQuote{Fudge} dice in six color schemes (color controlled by their suit).
\dQuote{Fudge} dice have three ranks "+", " ", and "-" repeated twice.}
\item{dominoes, dominoes_black, dominoes_blue, dominoes_green, dominoes_red, dominoes_white, dominoes_yellow}{
Traditional pipped dominoes in six color schemes (\code{dominoes} and \code{dominoes_white} are the same).
In each color scheme the number of pips on the \dQuote{top} of the domino is
controlled by their \dQuote{rank} and on the \dQuote{bottom} by their \dQuote{suit}.
Supports up to double-18 sets.}
\item{dominoes_chinese, dominoes_chinese_black}{\code{dominoes_chinese} has Asian-style six-sided pipped dice with
white background and black and red pips.
The \dQuote{tile}'s are Chinese dominoes (1" x 2.5") whose number of pips are controlled
by both their \dQuote{rank} and their \dQuote{suit}. \code{dominoes_chinese_black} are like \code{dominoes_chinese} but the
dice and dominoes have a black background and white and red pips.}
\item{go}{Go stones and lined boards in six color schemes.
Go stones are represented by a \dQuote{bit} and the board is a \dQuote{board}.
Color is controlled by suit and number of rows/columns by rank.}
\item{meeples}{Standard 16mm x 16mm x 10mm \dQuote{meeples} in six colors represented by a \dQuote{bit}.}
\item{morris}{Various morris aka mills aka merels games in six colors.
Color is controlled by suit and \dQuote{size} of morris board
is controlled by rank e.g. \dQuote{Six men's morris} corresponds to a rank of 6 and
\dQuote{Nine men's morris} corresponds to a rank of 9.
Game pieces are represented by stones.}
\item{piecepack, dual_piecepacks_expansion, playing_cards_expansion, hexpack, subpack, piecepack_inverted}{
The piecepack is a public domain game system invented by James "Kyle" Droscha.
See \url{https://www.ludism.org/ppwiki} for more info about the piecepack and its accessories/expansions.
\describe{
\item{piecepack}{A standard piecepack.  The configuration also contains the following piecepack accessories:\describe{
\item{piecepack dice cards}{An accessory proposed by John Braley.
See \url{https://www.ludism.org/ppwiki/PiecepackDiceCards}.}
\item{piecepack matchsticks}{A public domain accessory developed by Dan Burkey.
See \url{https://www.ludism.org/ppwiki/PiecepackMatchsticks}.}
\item{piecepack pyramids}{A public domain accessory developed by Tim Schutz.
See \url{https://www.ludism.org/ppwiki/PiecepackPyramids}.}
\item{piecepack saucers}{A public domain accessory developed by Karol M. Boyle at Mesomorph Games.
See \url{https://web.archive.org/web/20190719155827/http://www.piecepack.org/Accessories.html}.}}}
\item{piecepack_inverted}{The standard piecepack with its color scheme inverted.
Intended to aid in highlighting special pieces in diagrams.}
\item{dual_piecepacks_expansion}{A companion piecepack with a special suit scheme.
See \url{https://trevorldavis.com/piecepackr/dual-piecepacks-pnp.html}.}
\item{playing_cards_expansion}{A piecepack with the standard \dQuote{French} playing card suits.
See \url{https://www.ludism.org/ppwiki/PlayingCardsExpansion}.}
\item{hexpack}{A hexagonal extrapolation of the piecepack designed by Nathan Morse and Daniel Wilcox.
See \url{https://boardgamegeek.com/boardgameexpansion/35424/hexpack}.}
\item{subpack}{A mini piecepack.  Designed to be used with the \code{piecepack} to make piecepack
\dQuote{stackpack} diagrams.  See \url{https://www.ludism.org/ppwiki/StackPack}.}
}}
\item{playing_cards, playing_cards_colored, playing_cards_tarot}{
Poker-sized \code{card} components for various playing card decks:\describe{
\item{playing_cards}{A traditional deck of playing cards with 4 suits
and 13 ranks (A, 2-10, J, Q, K) plus a 14th \dQuote{Joker} rank.}
\item{playing_cards_colored}{Like \code{playing_cards} but with five colored suits:
red hearts, black spades, green clubs, blue diamonds, and yellow stars.}
\item{playing_cards_tarot}{A (French Bourgeois) deck of tarot playing cards:
first four suits are hearts, spades, clubs, and diamonds with
14 ranks (ace through jack, knight, queen, king) plus a 15th \dQuote{Joker} rank
and a fifth "suit" of 22 trump cards (1-21 plus an \dQuote{excuse}).}}}
\item{reversi}{Boards and pieces for Reversi.
"board_face" provides lined boards with colored backgrounds.
"board_back" provides checkered boards.
"bit_face" / "bit_back" provides circular game tokens with differently colored sides:
red paired with green, black paired with white, and blue paired with yellow.
}
}
}
\examples{
cfgs <- game_systems(pawn = "joystick")
names(cfgs)

\donttest{# May take more than 5 seconds on CRAN servers
# standard dice, meeples, and joystick pawns
if (requireNamespace("grid", quietly = TRUE) && piecepackr:::device_supports_unicode()) {
   opt <- options(piecepackr.at.inform = FALSE)
   grid::grid.newpage()
   dice <-  c("d4", "numeral", "d8", "d10", "d12", "d20")
   cfg <- paste0("dice_", dice)
   grid.piece("die_face", suit = c(1:6, 1), rank = 1:6,
              cfg = cfg, envir = cfgs, x = 1:6, y = 1,
              default.units = "in", op_scale = 0.5)
   grid.piece("die_face", rank=1:6, suit=1:6,
              x=1:6, y=2, default.units="in",
              op_scale=0.5, cfg=cfgs$dice)
   grid.piece("bit_face", suit=1:6,
              x=1:6, y=3, default.units="in",
              op_scale=0.5, cfg=cfgs$meeple)
   grid.piece("pawn_top", suit=1:6,
              x=1:6, y=4, default.units="in",
              op_scale=0.5, cfg=cfgs$piecepack)
   options(opt)
}
}
# dominoes
if (requireNamespace("grid", quietly = TRUE)) {
   grid::grid.newpage()
   colors <- c("black", "red", "green", "blue", "yellow", "white")
   cfg <- paste0("dominoes_", rep(colors, 2))
   grid.piece("tile_face",  suit=1:12, rank=1:12+1,
              cfg=cfg, envir=cfgs,
              x=rep(6:1, 2), y=rep(2*2:1, each=6),
              default.units="in", op_scale=0.5)
}
# piecepack "playing card expansion"
if (requireNamespace("grid", quietly = TRUE) && piecepackr:::device_supports_unicode()) {
   grid::grid.newpage()
   df_tiles <- data.frame(piece_side="tile_back",
                          x=0.5+c(3,1,3,1), y=0.5+c(3,3,1,1),
                          suit=NA, angle=NA, z=1/8,
                          stringsAsFactors=FALSE)
   df_coins <- data.frame(piece_side="coin_back",
                          x=rep(4:1, 4), y=rep(4:1, each=4),
                          suit=c(1,4,1,4,4,1,4,1,2,3,2,3,3,2,3,2),
                          angle=rep(c(180,0), each=8), z=1/4+1/16,
                          stringsAsFactors=FALSE)
   df <- rbind(df_tiles, df_coins)
   pmap_piece(df, cfg = cfgs$playing_cards_expansion, op_scale=0.5,
              default.units="in")
}
}
\seealso{
\code{\link{pp_cfg}} for information about the \code{pp_cfg} objects returned by \code{game_systems}.
}
