% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pnp.R
\name{save_print_and_play}
\alias{save_print_and_play}
\title{Save piecepack print-and-play (PnP) file}
\usage{
save_print_and_play(
  cfg = pp_cfg(),
  output_filename = "piecepack.pdf",
  size = "letter",
  pieces = c("piecepack", "matchsticks", "pyramids"),
  arrangement = "single-sided"
)
}
\arguments{
\item{cfg}{Piecepack configuration list}

\item{output_filename}{Filename for print-and-play file}

\item{size}{PnP output size (currently either "letter", "A4", or "A5")}

\item{pieces}{Character vector of desired PnP pieces.
Supports "piecepack", "matchsticks", "pyramids", "subpack", or "all".}

\item{arrangement}{Either "single-sided" or "double-sided".}
}
\description{
Save piecepack print-and-play (PnP) file
}
\examples{
  \donttest{
    if (capabilities("cairo")) {
        cfg <- pp_cfg(list(invert_colors.suited=TRUE))
        save_print_and_play(cfg, "my_pnp_file.pdf")
        save_print_and_play(cfg, "my_pnp_file_ds.pdf", arrangement="double-sided")
        save_print_and_play(cfg, "my_pnp_file_A4.pdf", size="A4", pieces="all")
        save_print_and_play(cfg, "my_pnp_file_A5.pdf", size="A5")
        unlink("my_pnp_file.pdf")
        unlink("my_pnp_file_ds.pdf")
        unlink("my_pnp_file_A4.pdf")
        unlink("my_pnp_file_A5.pdf")
    }
  }
}
