% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_cft.R
\name{check.cft}
\alias{check.cft}
\title{Check that expected value of counterfactual decreases exposure levels}
\usage{
check.cft(cft, X)
}
\arguments{
\item{cft}{Function \code{cft(X)} for counterfactual. Leave empty for 
the Population Attributable Fraction \code{\link{paf}} where counterfactual
is 0 exposure.}

\item{X}{Random sample (data.frame) which includes exposure and
covariates or sample mean.}
}
\value{
TRUE if counterfactual \code{cft} is well defined.
}
\description{
Function that checks whether the counterfactual function of
  \code{\link{pif}} decreases the exposure values \code{X}.
}
\examples{

#Example 1 
cft <- function(X){0.5*X}
X   <- runif(100, 0,2)
check.cft(cft, X)

}
\seealso{
\code{\link{check.confidence}}, \code{\link{check.thetas}}, 
  \code{\link{check.xvar}}, \code{\link{check.rr}}, 
  \code{\link{check.exposure}}, \code{\link{check.integrals}}
}
\author{
Rodrigo Zepeda-Tello \email{rzepeda17@gmail.com}

Dalia Camacho-García-Formentí \email{daliaf172@gmail.com}
}
\keyword{internal}
