\name{genedmhtml}
\alias{genedmhtml}
\title{Generate HTML and perl files to enable tree traversal}
\description{
	Called by pinktoe to traverse a tree and generate appropriate
	perl and HTML files that enable a CGI-enabled web-server to
	graphically traverse a tree.
}
\usage{
genedmhtml(treeobj, noderow, edmtextfn, edmtittext, cgibindir, htmldir, localdir, stateprintfn, requirelib, commonhtml)
}
\arguments{
  \item{treeobj}{ A \code{tree} or \code{rpart} object to traverse }
  \item{noderow}{ The row to begin at}
  \item{edmtextfn}{ A function that can print out explanatory text given a variable name (see web help page and \code{edm.text} example. }
  \item{edmtittext}{ Prints out a title string given a variable name }
  \item{cgibindir}{ A character string containing the directory where the perl
        files generated by pinktoe (with the extension \code{.pl}) will be
        stored.
        (This should be the directory part of the URL of the cgi-bin
        directory). }

  \item{htmldir}{ A character string containing the directory where the HTML
                files generated by pinktoe (with the extension \code{.htm})
                will be stored.  (This should be a pathname understood and
                able to be found by perl).  }
  \item{localdir}{A local location to store both the HTML and perl files
        immediately after they are generated }

  \item{stateprintfn}{A user-supplied function that decides what to do when
        supplied with the \code{yval} reached at the leaf of a tree. Some
        text can be output, or maybe a perl function call.  }

  \item{requirelib}{A library of perl functions that can be called by, e.g.
        \code{stateprintfn}. The library that this refers to
        should reside in the \code{cgibin} directory. If no function calls
        are planned then it doesn't matter what argument is supplied.}

  \item{commonhtml}{A user-supplied function that prints out some HTML code.
        This is appended to every HTML web page.}

}
\details{
}
\value{ No deliberate return value.  }
\references{ 
\url{http://www.stats.bris.ac.uk/~magpn/Research/Pinktoe/Welcome.html}
}
\author{Guy P Nason }
\note{ Not intended for general user use}

\seealso{ \code{\link{pinktoe}}}
\examples{
#
#Not intended for general user use
#
}
\keyword{ datagen }% at least one, from doc/KEYWORDS
