% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/board_registration.R
\name{board_register_github}
\alias{board_register_github}
\title{Register GitHub Board}
\usage{
board_register_github(name = "github", repo = NULL,
  branch = "master", token = NULL, path = "",
  cache = board_cache_path(), ...)
}
\arguments{
\item{name}{Optional name for this board, defaults to 'github'.}

\item{repo}{The GitHub repository formatted as 'owner/repo', can be
\code{NULL} if the \code{GITHUB_PAT} environment variable is set.}

\item{branch}{The branch to use when commiting pins.}

\item{token}{Token to use when \code{GITHUB_PAT} is not specified.}

\item{path}{The subdirectory in the repo where the pins will be stored.}

\item{cache}{The local folder to use as a cache, defaults to \code{board_cache_path()}.}

\item{...}{Additional parameters required to initialize a particular board.}
}
\description{
Wrapper with explicit parameters over \code{board_register()} to
register a GitHub repo as a board.
}
\details{
This function requires a GitHub repo to be manually created; otherwise,
registering a GitHub board will fail.

When a file upload exceeds 25MB, a GitHub release file will be used since
they support up to 2GB file uploads. This threshold can be configured through
the \code{pins.github.release} option which is specified in megabytes and
defaults to \code{25}.
}
\examples{
\dontrun{
# the following example requires a GitHub API key
board_register_github(repo = "owner/repo")
}
}
\seealso{
board_register
}
