% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_twin_alignment.R
\name{sim_twin_alignment}
\alias{sim_twin_alignment}
\title{Creates a twin alignment.}
\usage{
sim_twin_alignment(
  twin_phylogeny,
  true_alignment,
  alignment_params,
  twinning_params
)
}
\arguments{
\item{twin_phylogeny}{a phylogeny of class \link[ape]{phylo}}

\item{true_alignment}{a DNA alignment, of class \link[ape]{DNAbin}}

\item{alignment_params}{parameters to simulate an alignment,
as can be created by \link{create_alignment_params}}

\item{twinning_params}{can be \code{NA} if no twinning is desired,
or can be the twinning parameters,
as can be created by \link{create_twinning_params}}
}
\value{
an alignment of class DNAbin that has as much
  mutations accumulated from crown to the tips as the
  original, 'true' alignment
}
\description{
A twin alignment is an alignment that has as much acquired
the same number of mutations (compared to the root sequence),
as the true alingment has (compared to the root sequence).
}
\details{
When an alignment gets very big, say one million base pairs,
it will take long to get a twin alignment with exactly the same
number of mutations.
}
\examples{
true_phylogeny <- ape::read.tree(text = "((A:1, B:1):2, C:3);")
twin_phylogeny <- ape::read.tree(text = "((A:2, B:2):1, C:3);")
root_sequence <- create_blocked_dna(1000)
alignment_params <- create_test_alignment_params()
true_alignment <- create_true_alignment(
  true_phylogeny = true_phylogeny,
  alignment_params = alignment_params
)
twin_alignment <- sim_twin_alignment(
  twin_phylogeny = twin_phylogeny,
  true_alignment = true_alignment,
  alignment_params = alignment_params,
  twinning_params = create_twinning_params()
)
}
\author{
Richèl J.C. Bilderbeek, Giovanni Laudanno
}
