% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_std_pir_paramses.R
\name{create_std_pir_paramses}
\alias{create_std_pir_paramses}
\title{Create a number of standard \code{pir_params}}
\usage{
create_std_pir_paramses(
  n,
  folder_name = rappdirs::user_cache_dir(),
  rng_seed = 314,
  crown_age = 10,
  sequence_length = 1000,
  mutation_rate = 1/crown_age,
  os = rappdirs::app_dir()$os
)
}
\arguments{
\item{n}{number of \code{pir_params}}

\item{folder_name}{name of the main folder}

\item{rng_seed}{a random number generator seed}

\item{crown_age}{the fixed crown age of the posterior. Set to NA
to let it be estimated}

\item{sequence_length}{the length of each DNA sequence in an alignment}

\item{mutation_rate}{the mutation rate per base pair per time unit.
Use \link{check_mutation_rate} to check if a mutation rate is valid.}

\item{os}{name of the operating system, can be \code{mac}, \code{unix}
or \code{win}. Use \link[beastier]{check_os} if the operating system
is valid.}
}
\value{
a \link{list} or \code{pir_params}, dubbed a \code{pir_paramses}.
  Use \link{check_pir_paramses} to check this list for validity.
}
\description{
Create a number of standard \code{pir_params}
}
\examples{
\donttest{
  pir_paramses <- create_std_pir_paramses(n = 2)
  check_pir_paramses(pir_paramses)
}
}
