% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/place_rule.R
\name{place_rule}
\alias{place_rule}
\alias{is.rule_points}
\title{Places a line on the rgb plot}
\usage{
place_rule(x_axis, y_axis, line_type = "f")

is.rule_points(x)
}
\arguments{
\item{x_axis}{a character string indicating the colour variable that
corresponds to the x axis, one of \code{"r"}, \code{"g"} or \code{"b"}.}

\item{y_axis}{a character string indicating the colour variable that
corresponds to the y axis, one of \code{"r"}, \code{"g"} or \code{"b"}.}

\item{line_type}{a character string indicating that the line is vertical
(\code{"v"}), horizontal (\code{"h"}) or free (\code{"f"}, the default).}

\item{x}{the R object being tested}
}
\value{
An object of class \code{"pixel_rule_points"} containing these
  elements:
\itemize{
\item \code{x_axis}: a character string containing the colour variable
  selected as \code{x} axis (one of "r, "g or "b").
\item \code{y_axis}: a character string containing the colour variable
  selected as \code{y} axis.
}
}
\description{
A wrapper function for \code{graphics::locator} that helps in creating rules.
}
\details{
This function calls \code{graphics::locator} on a previously plotted
  rgb plane to select two points with the mouse. Then it plots the line
  joining them and returns an object of class \code{"pixel_rule_object"}.
  These objects are passed as parameters to \code{pixel_rule()} to create
  \code{"pixel_rule"} objects.

  True horizontal and vertical lines are difficult to create by hand. In
  these cases, specifying \code{"vertical"} or \code{"horizontal"} (partial
  match allowed, i.e. \code{"h"}) will copy the appropriate coordinate value
  from the first point to the second to make them the same. Note that this is
  done after \code{locator()} returns, so the plot will show the line joining
  the original points, not the corrected ones. Use \code{plot_rule()} to see
  the corrected line.
}
\examples{
\dontrun{
plot_rgb_plane("r", "g")
line01 <- place_rule("r", "g")          # A "free" line
line02 <- place_rule("r", "g", "h")     # A horizontal line
}

}
\seealso{
\code{\link[graphics]{locator}}, \code{\link{pixel_rule}},
  \code{\link{plot_rule}}, \code{\link{plot_rgb_plane}}
}
