% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dep-utils.R
\name{as_pkg_dependencies}
\alias{as_pkg_dependencies}
\title{Shorthands for dependency specifications}
\usage{
as_pkg_dependencies(deps)
}
\arguments{
\item{deps}{See below.}
}
\value{
A named list with two character vectors: \code{direct}, \code{indirect},
the dependency types to use for direct installations and dependent
packages.
}
\description{
Shorthands for dependency specifications
}
\details{
Supports concise ways of specifying which types of dependencies of
a package should be installed. It is similar to how
\code{\link[utils:install.packages]{utils::install.packages()}} interprets its \code{dependencies} argument.
Possible values for the \code{deps} argument are:
\itemize{
\item \code{TRUE}: This means all hard dependencies plus \code{Suggests} for
direct installations, and hard dependencies only for dependent
packages.
\item \code{FALSE}: no dependencies are installed at all.
\item \code{NA} (any atomic type, so \code{NA_character_}, etc. as well): only hard
dependencies are installed. See \code{\link[=pkg_dep_types_hard]{pkg_dep_types_hard()}}.
\item If a list with two entries named \code{direct} and \code{indirect}, it is taken
as the requested dependency types, for direct installations and
dependent packages.
\item If a character vector, then it is taken as the dependency types
for direct installations, and the hard dependencies are
used for the dependent packages.
}

If \code{"hard"} is included, then it is replaced by the hard dependency
types. If \code{"soft"} or \code{"all"} is included, then it is replaced by all
dependency types.
\subsection{Extra dependencies}{

pkgdepends supports extra dependency types for direct installations.
These are specified with a \verb{Config/Needs/} prefix in \code{DESCRIPTION}
and they can contain package references, separated by commas.
For example you can specify packages that are only needed for the
pkgdown website of the package:

\if{html}{\out{<div class="sourceCode">}}\preformatted{Config/Needs/website: r-lib/pkgdown
}\if{html}{\out{</div>}}
}
}
\seealso{
Other package dependency utilities: 
\code{\link{pkg_dep_types_hard}()}
}
\concept{package dependency utilities}
