% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{verify_ascii}
\alias{verify_ascii}
\title{Check if a file contains only ASCII characters}
\usage{
verify_ascii(input, quiet = FALSE)
}
\arguments{
\item{input}{Path to the text file.}

\item{quiet}{Print the elements containing non-ASCII characters?}
}
\value{
Logical. \code{TRUE} if the file only contains ASCII characters,
\code{FALSE} otherwise.
}
\description{
Check if a file contains only ASCII characters
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Read the file and check for non-ASCII characters in its content.
    \item If there are non-ASCII characters, return \code{FALSE}, otherwise \code{TRUE}.
    \item If \code{quiet = FALSE} and there are non-ASCII characters,
    print the corresponding line numbers and the non-ASCII characters.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
pkg <- system.file("examples/pkg1", package = "pkglite")
txt <- tempfile(fileext = ".txt")

pkg \%>\%
  collate(file_default()) \%>\%
  pack(output = txt, quiet = TRUE) \%>\%
  verify_ascii()
}
