% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/collection.R
\name{merge.file_collection}
\alias{merge.file_collection}
\title{Merge file collections}
\usage{
\method{merge}{file_collection}(x, y, ...)
}
\arguments{
\item{x}{File collection.}

\item{y}{Another file collection.}

\item{...}{Additional file collections.}
}
\value{
Merged file collection.
}
\description{
Merge file collections
}
\section{Specification}{

\if{latex}{
  \itemize{
    \item Capture the file collection objects and store in a list.
    \item Check if all objects are file collection objects.
    \item Check if the file collections are for the same package.
    \item Bind the data frames from the file collections together and
    remove duplicated rows.
    \item Create a new file collection object with the merged data frame.
  }
}
\if{html}{The contents of this section are shown in PDF user manual only.}
}

\examples{
pkg <- system.file("examples/pkg1/", package = "pkglite")
fc1 <- pkg \%>\% collate(file_root_core())
fc2 <- pkg \%>\% collate(file_r(), file_man())
merge(fc1, fc2)
}
