% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dev-help.r
\name{help}
\alias{help}
\alias{shim_help}
\alias{?}
\alias{shim_question}
\title{Drop-in replacements for help and ? functions}
\usage{
# help(topic, package = NULL, ...)

# ?e2
# e1?e2
}
\arguments{
\item{topic}{A name or character string specifying the help topic.}

\item{package}{A name or character string specifying the package in which
to search for the help topic. If NULL, search all packages.}

\item{...}{Additional arguments to pass to \code{\link[utils:help]{utils::help()}}.}

\item{e1}{First argument to pass along to \verb{utils::}?``.}

\item{e2}{Second argument to pass along to \verb{utils::}?``.}
}
\description{
The \verb{?} and \code{help} functions are replacements for functions of the
same name in the utils package. They are made available when a package is
loaded with \code{\link[=load_all]{load_all()}}.
}
\details{
The \verb{?} function is a replacement for \code{\link[utils:Question]{utils::?()}} from the
utils package. It will search for help in devtools-loaded packages first,
then in regular packages.

The \code{help} function is a replacement for \code{\link[utils:help]{utils::help()}} from
the utils package. If \code{package} is not specified, it will search for
help in devtools-loaded packages first, then in regular packages. If
\code{package} is specified, then it will search for help in devtools-loaded
packages or regular packages, as appropriate.
}
\examples{
\dontrun{
# This would load devtools and look at the help for load_all, if currently
# in the devtools source directory.
load_all()
?load_all
help("load_all")
}

# To see the help pages for utils::help and utils::`?`:
help("help", "utils")
help("?", "utils")

\dontrun{
# Examples demonstrating the multiple ways of supplying arguments
# NB: you can't do pkg <- "ggplot2"; help("ggplot2", pkg)
help(lm)
help(lm, stats)
help(lm, 'stats')
help('lm')
help('lm', stats)
help('lm', 'stats')
help(package = stats)
help(package = 'stats')
topic <- "lm"
help(topic)
help(topic, stats)
help(topic, 'stats')
}
}
