% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/light_proj_inv.R
\name{light_proj_inv}
\alias{light_proj_inv}
\title{Calculates projected inventories and coverages}
\usage{
light_proj_inv(dataset, DFU, Period, Demand, Opening, Supply)
}
\arguments{
\item{dataset}{a dataframe with the demand and supply features for an item per period}

\item{DFU}{name of an item, a SKU, or a node like an item x location}

\item{Period}{a period of time monthly or weekly buckets for example}

\item{Demand}{the quantity of an item planned to be consumed in units for a given period}

\item{Opening}{the opening inventories of an item in units at the beginning of the horizon}

\item{Supply}{the quantity of an item planned to be supplied in units for a given period}
}
\value{
a dataframe with the calculated projected inventories and coverages and the related analysis
}
\description{
Calculates projected inventories and coverages
}
\examples{
light_proj_inv(dataset = blueprint_light, DFU, Period, Demand, Opening, Supply)

}
