% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{demo_in_transit}
\alias{demo_in_transit}
\title{demo_in_transit}
\format{
A data frame with 447 rows and 6 variables
}
\usage{
data(demo_in_transit)
}
\description{
This dataset contains the detailed ETA and ETD for the current and next in transit, as well as the Transit Time for a defined DFU.
ETA stands for Estimated Time of Arrival.
ETD stands for Estimated Time of Departure.
There are 2 types of in transit : the current in transit and the next one, not yet shipped.
There are 6 variables in this dataset: a DFU, a Period, an ETA Current Goods In Transit, an ETD & ETA Next Goods In Transit, and a Transit Time.
Note that the diffrence between ETD and ETA is the Transit Time.
The idea is to use this dataset to project the Goods In Transit.
We can apply on this dataset the proj_git() function, it will calculate the Proj.GIT which gathers the current and next In Transit quantities.
}
\details{
\itemize{
\item DFU, a location and an item
\item Period, a date in weekly bucket format
\item ETA.Current, some quantities currently in transit displayed at their ETA date in units
\item ETA.Next, some quantities to be shipped, not yet in transit, displayed at their ETA date in units
\item ETD.Next, some quantities to be shipped, not yet in transit, displayed at their ETD date in units
\item TLT, the Transit Lead Time, expressed in weeks, represents the difference between ETA and ETD dates

}
}
\author{
Nicolas Nguyen \email{nikonguyen@yahoo.fr}
}
