% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{alloc_data}
\alias{alloc_data}
\title{alloc_data}
\format{
A data frame with 85 rows and 10 variables
}
\usage{
data(alloc_data)
}
\description{
This dataset contains the basic features to calculate the allocation of a Demand between different receiving entities.
Just 5 key features are needed for this: a DFU, a Period, a Demand, an initial Opening Inventory and a Supply Plan.
And the breakdown of the Demand by receiving entities, here 5 different Distributors.
The idea is to use this dataset to calculate a constrained demand for each Product, on top of the projected inventories & coverages.
And to allocate this constrained demand based on the percentage of demand that each receiving entities represents for a given period of time.
It's a concept of fair allocation.
A constrained demand is a possible demand, which can be answered considering the projected inventories.
Then we can apply on this dataset the const_dmd() function, it will add 2 variables : a Constrained.Demand and a Current.Stock.Available.Tag .
The Constrained.Demand is the Demand which can be answered considering the projected inventories, i.e which quantity can be answered and when it can be answered.
The function alloc_dmd() will allocate this constrained demand between receiving entities.
}
\details{
\itemize{
\item DFU, an item
\item Period, a date
\item Dist1, a consumption in units related to the distributor 1
\item Dist2, a consumption in units related to the distributor 2
\item Dist3, a consumption in units related to the distributor 3
\item Dist4, a consumption in units related to the distributor 4
\item Dist5, a consumption in units related to the distributor 5
\item Demand, a consumption in units
\item Opening, available inventories at the beginning in units
\item Supply, a Replenishment Plan in units

}
}
\author{
Nicolas Nguyen \email{nikonguyen@yahoo.fr}
}
