% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Scale.R
\name{Scale}
\alias{Scale}
\title{Imposes scaling constraint to identify parameters LMA (nominal) model}
\usage{
Scale(
  Master,
  item.log,
  Phi.mat,
  PersonByItem,
  npersons,
  nitems,
  ncat,
  nless,
  ntraits,
  item.by.trait
)
}
\arguments{
\item{Master}{Current Master data frame.}

\item{item.log}{Iteration history of LogLike, lambda, and item parameters}

\item{Phi.mat}{Current phi matrix}

\item{PersonByItem}{inData}

\item{npersons}{Number of persons}

\item{nitems}{Number of items}

\item{ncat}{Number of categories}

\item{nless}{Number of unique nus (ncat-1)}

\item{ntraits}{Number of (latent) dimensions}

\item{item.by.trait}{Indicates the trait an item load on.}
}
\value{
Master       Master frame with re-scaled scale values

Phi.mat		   Re-scaled matrix of association parameters
}
\description{
Scaling is internal to the function 'fit.nominal', which corresponds
the the nominal item response theory model.  It imposes the required
scaling identification constraint by transforming the conditional
covariance matrix 'Phi.mat' to a conditional correlation matrix (i.e.,
set phi_mm=1 for all m). The inverse transformation is applied to
the current category scale value estimates and these are put back
into the Master data frame so that data are ready for the next
iteration of the algorithm.
}
