% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_independence.R
\name{fit.independence}
\alias{fit.independence}
\title{Fits the log-linear model of independence}
\usage{
fit.independence(Master, LambdaNames, LambdaName, ItemNames)
}
\arguments{
\item{Master}{Master data set from set.up}

\item{LambdaNames}{Needed to define formula}

\item{LambdaName}{Used for column names of matrix estimates}

\item{ItemNames}{Used for row names of number of item by parameter matrix of
estimated Lambda parameters}
}
\value{
phi.mlogit     Parameters estimates and mlpl = logLike output from mnlogit

fstack          Formual used in stacked regression

estimates       Item by parameter estimates matrix

mlpl.phi        Maximum of log pseudo-likelihood from stacked regression

AIC             Akaike information criterion for pseudo-likelihood (smaller is better)

BIC             Bayesian information criterion for pseudo-likelihood (smaller is better)
}
\description{
This function fits by the log-linear model of independence (i.e., only
includes marginal effect terms) using pseudo-likelihood estimation.
This provides a baseline model with which to compare other models.
The independence maximumn of the loglikehood can be used is a measure
of no association. The input to the function is only the Master data
set and the names of marginal effect terms and items, all of which
are created by the 'set.up' function.  This function is called from
'ple.lma' or can be run output of wrapper.
}
\examples{
#--- data and set-up
data(dass)
inData <- dass[1:250,c("d1", "d2", "d3", "a1","a2","a3","s1","s2","s3")]
s <- set.up(inData, model.type='independence')

#--- fit independence model
ind <- fit.independence(s$Master, s$LambdaNames, s$LambdaName, s$ItemNames)

}
