% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_segment}
\alias{mosaic_segment}
\title{Segment a mosaic}
\usage{
mosaic_segment(
  mosaic,
  index = "R",
  r = 3,
  g = 2,
  b = 1,
  re = NA,
  nir = NA,
  swir = NA,
  tir = NA,
  threshold = "Otsu",
  invert = FALSE,
  return = c("mosaic", "mask")
)
}
\arguments{
\item{mosaic}{A mosaic of class \code{SpatRaster}, generally imported with
\code{\link[=mosaic_input]{mosaic_input()}}.}

\item{index}{A character value (or a vector of characters) specifying the
target mode for conversion to a binary image. Use \code{\link[=pliman_indexes_rgb]{pliman_indexes_rgb()}}
and \code{\link[=pliman_indexes_me]{pliman_indexes_me()}} to see the available RGB and multispectral
indexes, respectively. Users can also calculate their own index using  \verb{R, G, B, RE, NIR, SWIR, and TIR} bands (eg., \code{index = "R+B/G"}) or using the
names of the mosaic's layers (ex., "(band_1 + band_2) / 2").}

\item{r, g, b, re, nir, swir, tir}{The red, green, blue, red-edge,  near-infrared,
shortwave Infrared, and thermal infrared bands of the image, respectively.
By default, the function assumes a BGR as input (b = 1, g = 2, r = 3). If a
multispectral image is provided up to seven bands can be used to compute
built-in indexes. There are no limitation of band numbers if the index is
computed using the band name.}

\item{threshold}{By default (threshold = "Otsu"), a threshold value based on
Otsu's method is used to reduce the grayscale image to a binary image. If a
numeric value is provided, this value will be used as a threshold.}

\item{invert}{Logical, indicating whether to invert the mask. Defaults to
\code{FALSE}, i.e., pixels with intensity greater than the threshold values are
selected.}

\item{return}{The output of the function. Either 'mosaic' (the segmented
mosaic), or 'mask' (the binary mask).}
}
\value{
The segmented mosaic (\code{SpatRaster} object)
}
\description{
Segment a \code{SpatRaster} using a computed image index. By default, values
greater than \code{threshold} are kept in the mask.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
mosaic <- mosaic_input(system.file("ex/elev.tif", package="terra"))
seg <-
mosaic_segment(mosaic,
               index = "elevation",
               threshold = 350)
mosaic_plot(seg)
}
}
