% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_label}
\alias{image_label}
\title{Label Connected Components in a Binary Image}
\usage{
image_label(img, max_gap = 0)
}
\arguments{
\item{img}{A binary image matrix where \code{1} represents foreground pixels and
\code{0} represents background pixels. This should be compatible with the
EBImage package.}

\item{max_gap}{An integer specifying the maximum allowable gap (in pixels)
between connected components to be considered as part of the same object.
Default is \code{1}.}
}
\value{
An object of class \code{Image} (from the EBImage package), where each
connected component is assigned a unique integer label.
}
\description{
This function labels connected components in a binary image while allowing
for a specified maximum gap between pixels to still be considered part of
the same object.
}
\examples{
if(interactive()){
library(pliman)
img <- matrix(c(
  1, 1, 0, 0, 0, 1, 1, 1, 0,
  0, 0, 0, 0, 0, 1, 0, 0, 0,
  1, 1, 0, 0, 1, 1, 1, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 1
), nrow = 4, byrow = TRUE)

image_label(img, max_gap = 1)
image_label(img, max_gap = 2)
image_label(img, max_gap = 3)
}
}
