% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_shapefile.R
\name{line_on_halfplot}
\alias{line_on_halfplot}
\title{Extract mid‐lines from half‐plots}
\usage{
line_on_halfplot(shapefile)
}
\arguments{
\item{shapefile}{An \code{sf} object of polygons. Each geometry must be closed
(first and last coordinate coincide) so that \code{st_coordinates(...)}
yields a repeating start point.}
}
\value{
A \code{SpatVector} (from the \strong{terra} package) of line geometries
representing the half‐plot midlines.
}
\description{
For each polygon in an \code{sf} object, computes the line segment joining
the midpoints of the longer pair of opposite edges (the “half‐plot line”).
}
\examples{

if(interactive()){
library(pliman)
shp <- shapefile_input( paste0(image_pliman(), "/soy_shape.rds"))
mosaic <- mosaic_input( paste0(image_pliman(), "/soy_dsm.tif"))
mosaic_plot(mosaic)
half <- line_on_halfplot(shp)
shapefile_plot(half, add = TRUE, col = "blue")

}
}
