% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_clip}
\alias{mosaic_clip}
\title{Clip Raster Mosaic by Polygons}
\usage{
mosaic_clip(
  mosaic,
  shapefile,
  unique_id = "unique_id",
  out_dir = NULL,
  overwrite = TRUE,
  verbose = TRUE,
  exact = FALSE,
  parallel = FALSE,
  workers = NULL
)
}
\arguments{
\item{mosaic}{A \link[terra:SpatRaster-class]{terra::SpatRaster} object or a file path pointing to a raster.
In-memory rasters are first written to a temporary GeoTIFF.}

\item{shapefile}{An \link[sf:sf]{sf::sf}, \link[terra:SpatVector-class]{terra::SpatVector}, or path to a vector file.  Must
contain a column named \code{unique_id} for naming each output tile.}

\item{unique_id}{A column present in \code{shapefile} that uniquely identifies the
plots to be clipped.}

\item{out_dir}{Directory where clipped rasters will be saved.  Defaults to the current
working directory.  Created recursively if it does not exist.}

\item{overwrite}{Logical; if \code{TRUE} (the default), existing files in \code{out_dir} with the
same name will be overwritten.}

\item{verbose}{Logical; if \code{TRUE} (default), progress bars and status messages will be
shown.}

\item{exact}{Logical; if \code{FALSE} (default), tiles are cropped by each feature's
bounding box.  If \code{TRUE}, the function extracts each polygon as a cutline
for an exact crop (slower, but shape-accurate).}

\item{parallel}{Logical; if \code{TRUE} (default), processing is parallelized using \code{mirai}.
Set to \code{FALSE} for purely sequential execution.}

\item{workers}{Integer; number of parallel daemons to launch when \code{parallel = TRUE}.
Defaults to 70\% of available cores.}
}
\value{
Invisibly returns a character vector of file paths to all clipped GeoTIFFs.
}
\description{
Quickly partition a large raster mosaic into individual tiles using a
polygon layer.  Each tile is clipped by either the polygon's bounding box
or (optionally) the exact feature geometry, and written to disk as a separate
GeoTIFF named by the feature's \code{unique_id}.
}
\details{
Clip a Raster Mosaic by Polygons

This function wraps GDAL's \code{warp} utility for efficient raster clipping.
When \code{parallel = TRUE}, it will spawn multiple workers via \code{mirai} and
process tiles in batches.  Use \code{exact = TRUE} to clip to the true polygon
shape (at some extra cost), or leave \code{exact = FALSE} for a faster
bounding-box crop.
}
