#' Master's students' employment condition
#'
#' `data.frame` with 3282 cross-sectional observations of 7 variables about 
#' employment condition of master's students one year after graduation. Data
#' refer to students graduated at the University of Trento (Italy) between 2009
#' and 2013.
#'
#' @name cross_1year
#' @docType data
#'
#' @format
#' `data.frame` with 3282 observations of 7 variables:
#'
#' * `employment_sit` - employment situation, a
#'   `factor` with three levels: *Employed*, *Unemployed*, *Trainee*.
#' * `gender` - gender, a `factor` with two levels: *Male*, *Female*.
#' * `finalgrade` - final grade degree, a `factor` with three levels:
#'   *Low*, *Average*, *High*.
#' * `duration` - duration of studies, a `factor` with three levels:
#'   *Short*, *Average*, *Long*.
#' * `social_class` - social class, a `factor` with five levels:
#'   *Working class*, *White-collar workers*, *Lower middle class*,
#'   *Upper middle class*, *Unclassified*.
#' * `irregularity` - irregularity indicator of student's studies,
#'   a `factor` with three levels: *Low*, *Average*, *High*.
#' * `hsscore` - high school final score, a `numeric` between 60 and
#'   100.
#'
#' @references Santi F., M. M. Dickson, G. Espa (2018)
#' "A graphical tool for interpreting regression coefficients of trinomial logit
#' models", *The American Statistician*. \doi{10.1080/00031305.2018.1442368}
#'
#' @keywords data
NULL


