% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{emptyPlot}
\alias{emptyPlot}
\title{Utility function}
\usage{
emptyPlot(xlim, ylim, main = NULL, xlab = NULL, ylab = NULL, h0 = NULL,
  v0 = NULL, bty = "n", eegAxis = FALSE, ...)
}
\arguments{
\item{xlim}{A one- or two-value vector indicating the range of the x-axis. 
If \code{xlim} is a number, then it is assumed that the other value is 0. 
Thus, \code{xlim=3000} wil result in a x-axis ranging from 0 to 3000, 
and \code{xlim=-3} will result in a x-axis ranging from -3 to 0.
Optional, \code{xlim} can be a vector with categorical x-axis labels.}

\item{ylim}{A one- or two-value vector indicating the range of the y-axis. 
(See \code{xlim}) for more information.
Optional, \code{ylim} can be a vector with categorical y-axis labels.}

\item{main}{Title for the plot. Empty by default. 
Note: the title can be added later using \code{\link[graphics]{title}}.}

\item{xlab}{Label for x-axis. Empty by default. If no label is provided, 
use \code{\link[graphics]{mtext}} for adding axis labels.}

\item{ylab}{Label for y-axis. Empty by default. (See \code{xlab}.)}

\item{h0}{A vector indicating where to add solid horizontal lines for 
reference. By default no values provided.}

\item{v0}{A vector indicating where to add dotted vertical lines for 
reference. By default no values provided.}

\item{bty}{A character string which determined the type of box which is 
drawn about plots. If bty is one of "o", "l", "7", "c", "u", or "]" the 
resulting box resembles the corresponding upper case letter. A value of 
"n"  (the default) suppresses the box.}

\item{eegAxis}{Logical: whether or not to reverse the y-axis, plotting the 
negative amplitudes upwards as traditionally is done in EEG research.
If eeg.axes is TRUE, labels for x- and y-axis are provided, when not 
provided by the user. Default value is FALSE.}

\item{...}{Other arguments for plotting, see \code{\link[graphics]{par}}.}
}
\value{
An empty plot window.
}
\description{
Generate an empty plot window.
}
\examples{
# generate some measurements:
x <- runif(100,0,100)
y <- rpois(100,lambda=3)

# Setup empty plot window fitting for data:
emptyPlot(range(x), range(y))
# To add data, use lines() and points()
points(x,y, pch=16, col=alpha('steelblue'))

# Category labels:
emptyPlot(toupper(letters[1:5]), 1)
# order matters:
emptyPlot(sample(toupper(letters[1:5])), 1)
# actually, they are plotted on x-positions 1:5
points(1:5, rnorm(5, mean=.5, sd=.1))
# also possible for y-axis or both:
emptyPlot(c(200,700), toupper(letters[1:5]))
emptyPlot(as.character(8:3), toupper(letters[1:5]))
# change orientation of labels:
par(las=1)
emptyPlot(c(200,700), toupper(letters[1:5]))
par(las=0) # set back to default

# More options:
emptyPlot(range(x), range(y),
    main='Data', ylab='Y', xlab='Time')
# add averages:
m <- tapply(y, list(round(x/10)*10), mean)
lines(as.numeric(names(m)), m, type='o', pch=4)

# with vertical and horizontal lines:
emptyPlot(1, 1, h0=.5, v0=.75)
# eeg axis (note the axes labels):
emptyPlot(c(-200,1000), c(-5,5),
    main="EEG", v0=0, h0=0,
    eegAxis=TRUE)

# empty window:
emptyPlot(1,1,axes=FALSE)
# add box:
emptyPlot(1,1, bty='o')

}
\author{
Jacolien van Rij
}
\seealso{
Use \code{\link[graphics]{title}} and 
\code{\link[graphics]{mtext}}  for drawing labels and titles; 
use  \code{\link[graphics]{lines}} and \code{\link[graphics]{points}} 
for plotting the data; 
use \code{\link[graphics]{legend}} or 
\code{\link{legend_margin}} for adding a legend.

Other Functions for plotting: \code{\link{addInterval}},
  \code{\link{add_bars}}, \code{\link{add_n_points}},
  \code{\link{alphaPalette}}, \code{\link{alpha}},
  \code{\link{check_normaldist}},
  \code{\link{color_contour}}, \code{\link{dotplot_error}},
  \code{\link{drawDevArrows}}, \code{\link{errorBars}},
  \code{\link{fill_area}}, \code{\link{getCoords}},
  \code{\link{getFigCoords}}, \code{\link{getProps}},
  \code{\link{gradientLegend}},
  \code{\link{legend_margin}},
  \code{\link{marginDensityPlot}},
  \code{\link{plot_error}}, \code{\link{plot_image}},
  \code{\link{plotsurface}}
}

