% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stretchxy.R
\name{stretchxy}
\alias{stretchxy}
\title{Stretching Transformation}
\usage{
stretchxy(x, xlarge = 2, ylarge = 2, f = NULL, group = TRUE,
  todf = TRUE, checks = TRUE)
}
\arguments{
\item{x}{the input. It can be a data frame, matrix, tibble object, 
or a list of 
these kinds of objects. Each object must have exactly 2 columns 
and must be numeric without NA.}

\item{xlarge}{the enlarging extent in x dimension.
If it is smaller than 1, the shape will be shrinking.}

\item{ylarge}{the enlarging extent in y dimension.
If it is smaller than 1, the shape will be shrinking.}

\item{f}{argument passed to \code{split} to divide a data frame 
into a list of data frames. It should be a vector whose length is 
equal to the number of rows of x (if x is a data frame).}

\item{group}{default is TRUE. It indicates 
whether to add a 3rd column named 
"g" to label the group number of each group of points. It is useful 
when using \code{aes(...group=g)} with 'ggplot2'.}

\item{todf}{default is TRUE. It indicates whether to 
combine the output (a list) into a data frame.}

\item{checks}{default is TRUE. It indicates whether 
to check input validity. Do not turn it off unless you are sure 
that the input is OK.}
}
\value{
if \code{todf = TRUE}, the output will be a data frame
with coordinates of possibly several polygons, otherwise, 
it will be a list of data frames. Data frames have 2 columns
named "x" and "y", and if \code{group = TRUE}, a third column 
named "g" is added indicating group numbers.
}
\description{
A2 (output) is the result of enlarging (or shrinking) A1 (input) 
in x dimension and y dimension.
Note: the two shapes manifest enlarging or 
shrinking effect 
only when \code{ggplot2::coord_fixed()} is used.
}
\examples{
library(ggplot2)
dat1=data.frame(x=c(0, 1, 1), y=c(0, 0, 1))
dat2=data.frame(x=c(4, 5, 5, 4), y=c(0, 0, 3, 3))
dat3=stretchxy(list(dat1, dat2), xlarge=3, ylarge=c(3, 2), todf=TRUE)
ggplot()+coord_fixed()+
	geom_polygon(data=dat1, aes(x, y), fill="red", alpha=0.3)+
	geom_polygon(data=dat2, aes(x, y), fill="blue", alpha=0.3)+
	geom_polygon(data=dat3, aes(x, y, fill=g, group=g), fill="blue", alpha=0.3)	
}
