% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enlarge_raster.R
\name{enlarge_raster}
\alias{enlarge_raster}
\title{Enlarge a Color Matrix}
\usage{
enlarge_raster(x, n = c(10, 10), row_first = TRUE, space = "rgb")
}
\arguments{
\item{x}{a color matrix or raster. It should
have at least 1 row and 1 column with no NAs.}

\item{n}{a vector with 2 numbers. If it has 1 number, 
the number will be repeated twice. The two numbers 
indicate how many colors you will get in the result per 
row and per column. Default is \code{c(10, 10)}.}

\item{row_first}{enlarge rows first or enlarge columns 
first? Default is TRUE. The results are almost the same, 
so you do not need to change this.}

\item{space}{the \code{space} 
parameter used by \code{colorRampPalette}. It can be 
"rgb" (default) or "Lab".}
}
\description{
This is a convenient wrapper of 
\code{colorRampPalette} to enlarge 
a color matrix or raster.
}
\examples{
library(ggplot2)
# the original matrix
m=matrix(c(
	"red", "yellow", "green", 
	"blue", "purple", "cyan", 
	"black", "orange", "grey"), byrow=TRUE, nrow=3)
# enlarge the matrix
mm=enlarge_raster(m, c(15, 15), space="Lab")
ggplot()+xlim(0, 10)+ylim(0, 5)+coord_fixed()+
	annotation_raster(mm, 
		xmin=0, xmax=10, ymin=0, ymax=5, interpolate=TRUE)
}
