# plots data as radial lines or a polygon on a 24 hour "clockface" going 
# clockwise. clock.pos should be in decimal hours between 0 and 24.
# Remember to convert hour/minute values to hour/decimal values.
# example: clock24.plot(rnorm(16)+3,seq(5.5,20.5))

clock24.plot<-function(lengths,clock.pos,labels=NULL,label.pos=NULL,
 rp.type="r",...) {
 
 npos<-length(lengths)
 # if no positions are given, spread the lines out over the circle 
 if(missing(clock.pos)) clock.pos<-seq(0,24-24/(npos+1),length=npos)
 # start at "midnight" and go clockwise
 radial.pos<-pi*(450-clock.pos*15)/180
 if(is.null(labels))
  labels<-paste(0:23,"00",sep="")
 if(is.null(label.pos))
  label.pos<-seq(5*pi/2,7*pi/12,by=-pi/12)
 else label.pos<-pi*(450-clock.pos*15)/180
 radial.plot(lengths,radial.pos,labels=labels,label.pos=label.pos,
  rp.type=rp.type,...)
}

# plots data as radial lines or a polygon starting at the right and going
# counterclockwise.
# angles should be given in 0-360 values, use radial.plot for radians
# example: polar.plot(rnorm(20)+3,seq(90,280,by=10))

polar.plot<-function(lengths,polar.pos=NULL,labels,label.pos=NULL,
 start=0,clockwise=FALSE,rp.type="r",...) {
 
 npos<-length(lengths)
 # if no positions are given, add the average distance between positions so that
 # the first and last line don't overlap
 if(is.null(polar.pos)) radial.pos<-seq(0,(2-2/(npos+1))*pi,length=npos)
 else radial.pos<-pi*polar.pos/180
 if(start) start<-pi*start/180
 if(is.null(label.pos)) label.pos<-seq(0,1.89*pi,length=18)
 else label.pos<-pi*label.pos/180
 if(missing(labels)) labels<-as.character(seq(0,340,by=20))
 radial.plot(lengths,radial.pos,labels,label.pos,start=start,
  clockwise=clockwise,rp.type=rp.type,...)
}

# plots radial lines of length 'lengths', symbols at 'lengths' from the
# center or a polygon with corresponding vertices at 'radial.pos' in radians.
# starts at the 'east' position and goes counterclockwise unless
# the "start" and "clockwise" arguments are changed
# label.prop is the proportion of max(lengths) that gives the
# radial position of the labels

radial.plot<-function(lengths,radial.pos=NULL,labels=NA,label.pos=NULL,
 start=0,clockwise=FALSE,rp.type="r",label.prop=1.1,main="",xlab="",ylab="",
 line.col=par("fg"),mar=c(2,2,3,2),show.grid=TRUE,show.radial.grid=TRUE,
 grid.col="gray",grid.bg="transparent",grid.left=FALSE,grid.unit=NULL,
 point.symbols=NULL,point.col=NULL,show.centroid=FALSE,radial.lim=NULL,
 poly.col=NA,...) {
 
 if(is.null(radial.lim)) radial.lim<-range(lengths)
 length.dim<-dim(lengths)
 if(is.null(length.dim)) {
  npoints<-length(lengths)
  nsets<-1
  lengths<-matrix(lengths,nrow=1)
 }
 else {
  npoints<-length.dim[2]
  nsets<-length.dim[1]
  lengths<-as.matrix(lengths)
 }
 lengths<-lengths-radial.lim[1]
 lengths[lengths<0]<-NA
 if(is.null(radial.pos[1]))
  radial.pos<-seq(0,pi*(2-2/npoints),length.out=npoints)
 radial.pos.dim<-dim(radial.pos)
 if(is.null(radial.pos.dim))
  radial.pos<-matrix(rep(radial.pos,nsets),nrow=nsets,byrow=TRUE)
 else radial.pos<-as.matrix(radial.pos)
 if(clockwise) radial.pos<--radial.pos
 if(start) radial.pos<-radial.pos+start
 if(show.grid) {
  grid.pos<-pretty(radial.lim)
  if(grid.pos[1] <= radial.lim[1]) grid.pos<-grid.pos[-1]
  maxlength<-max(grid.pos-radial.lim[1])
  angles<-seq(0,1.96*pi,by=0.04*pi)
 }
 else {
  grid.pos<-NA
  maxlength<-diff(radial.lim)
 }
 oldpar<-par("xpd","mar","pty")
 par(mar=mar,pty="s")
 plot(c(-maxlength,maxlength),c(-maxlength,maxlength),type="n",axes=FALSE,
  main=main,xlab=xlab,ylab=ylab)
 par(xpd=TRUE)
 if(length(line.col) < nsets) line.col<-1:nsets
 rp.type<-unlist(strsplit(rp.type,""))
 if(match("s",rp.type,0)) {
  if(is.null(point.symbols)) point.symbols<-1:nsets
  if(length(point.symbols)<nsets)
   point.symbols<-rep(point.symbols,length.out=nsets)
  if(is.null(point.col)) point.col<-1:nsets
  if(length(point.col)<nsets)
   point.col<-rep(point.col,length.out=nsets)
 }
 # split up rp.type if there is a combination of displays
 for(i in 1:nsets) {
  # get the vector of x positions
  xpos<-cos(radial.pos[i,])*lengths[i,]
  # get the vector of y positions
  ypos<-sin(radial.pos[i,])*lengths[i,]
  # plot radial lines if rp.type == "r"    
  if(match("r",rp.type,0))
   segments(0,0,xpos,ypos,col=line.col[i],...)
  if(match("p",rp.type,0))
   polygon(xpos,ypos,border=line.col[i],col=poly.col,...)
  if(match("s",rp.type,0))
   points(xpos,ypos,pch=point.symbols[i],col=point.col[i],...)
  if(show.centroid)
   if(match("p",rp.type,0)) {
    nvertices<-length(xpos)
    # first get the "last to first" area component
    polygonarea<-xpos[nvertices]*ypos[1] - xpos[1]*ypos[nvertices]
    for(vertex in 1:(nvertices-1))
     polygonarea<-
      polygonarea+xpos[vertex]*ypos[vertex+1]-xpos[vertex+1]*ypos[vertex]
    polygonarea<-polygonarea/2
    centroidx<-
     (xpos[nvertices]+xpos[1])*(xpos[nvertices]*ypos[1]-xpos[1]*ypos[nvertices])
    centroidy<-
     (ypos[nvertices]+ypos[1])*(xpos[nvertices]*ypos[1]-xpos[1]*ypos[nvertices])
    for(vertex in 1:(nvertices-1)) {
     centroidx<-centroidx + (xpos[vertex]+xpos[vertex+1])*
      (xpos[vertex]*ypos[vertex+1]-xpos[vertex+1]*ypos[vertex])
     centroidy<-centroidy + (ypos[vertex]+ypos[vertex+1])*
      (xpos[vertex]*ypos[vertex+1]-xpos[vertex+1]*ypos[vertex])
    }
    points(centroidx/(6*polygonarea),centroidy/(6*polygonarea),
     col=point.col[i],pch=point.symbols[i],cex=2,...)
   
   }
   else
    points(mean(xpos),mean(ypos),col=point.col[i],pch=point.symbols[i],
     cex=2,...)
 }
 if(is.na(labels[1])) {
  label.pos<-seq(0,1.8*pi,length=9)
  labels<-as.character(round(label.pos,2))
 }
 if(is.null(label.pos[1])) {
  lablen<-length(labels)
  label.pos<-seq(0,pi*(2-2/lablen),length.out=lablen)
 }
 if(clockwise) label.pos<--label.pos
 if(start) label.pos<-label.pos+start
 xpos<-cos(label.pos)*maxlength
 ypos<-sin(label.pos)*maxlength
 if(show.radial.grid) segments(0,0,xpos,ypos,col=grid.col)
 xpos<-cos(label.pos)*maxlength*label.prop
 ypos<-sin(label.pos)*maxlength*label.prop
 boxed.labels(xpos,ypos,labels,ypad=0.7,border=FALSE)
 if(show.grid) {
  for(i in seq(length(grid.pos),1,by=-1)) {
   xpos<-cos(angles)*(grid.pos[i]-radial.lim[1])
   ypos<-sin(angles)*(grid.pos[i]-radial.lim[1])
   polygon(xpos,ypos,border=grid.col,col=grid.bg)
  }
  ypos<-rep(-maxlength/15,length(grid.pos))
  boxed.labels(grid.pos-radial.lim[1],ypos,as.character(grid.pos),border=FALSE)
  if(!is.null(grid.unit))
   text(maxlength*1.05,ypos,grid.unit,adj=0)
 }
 par(oldpar)
}
