\name{dA}
\Rdversion{1.1}
\alias{dA}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Derivative of normalization function
}
\description{
This function computes the derivative of the function \deqn{v\mapsto \frac{w}{\|w\|_A}}  with respect to y.
}
\usage{
dA(w,A, dw)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{w}{vector of length n.

}
\item{A}{square matrix that defines the norm}
  \item{dw}{derivative of w with respect to y. As y is a vector of length n, the derivative is a matrix of size nxn.
}
}

\value{
the Jacobian matrix of the normalization function. This is a matrix of size nxn.
}

\details{
The first derivative of the normalization operator is
\deqn{\frac{\partial}{\partial y}\left(w\mapsto \frac{w}{\|w\|_A}\right)=\frac{1}{\|w\|}\left(I_n - \frac{w w^ \top A}{w^\top w}\right) \frac{\partial w}{\partial y}}

}
\references{
Kraemer, N., Sugiyama M. (2011). "The Degrees of Freedom of Partial Least Squares Regression". Journal of the American Statistical Association. ahead of print. doi:10.1198/jasa.2011.tm10107
\url{http://pubs.amstat.org/doi/abs/10.1198/jasa.2011.tm10107}

Kraemer, N., Braun, M.L. (2007) "Kernelizing PLS, Degrees of Freedom, and Efficient Model Selection", Proceedings of the 24th International Conference on Machine Learning, Omni Press, 441 - 448 

}
\author{
Nicole Kraemer
}

\seealso{
\code{\link{normalize}}, \code{\link{dnormalize}}
}
\examples{
w<-rnorm(15)
dw<-diag(15)
A<-diag(1:15)
d.object<-dA(w,A,dw)
}
\keyword{math}
