% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render_pmap_shiny.R
\name{render_pmap_shiny}
\alias{render_pmap_shiny}
\title{Render process map as a web app}
\usage{
render_pmap_shiny(
   p,
   title = "Process Map",
   nodes_prune_percentage = 0.5,
   edges_prune_percentage = 0.5,
   options = NULL)
}
\arguments{
\item{p}{The process map created by \code{create_pmap()}}

\item{title}{The title you want to display on the web page}

\item{nodes_prune_percentage}{How many percentage of nodes should be pruned. Default is \code{0.5}}

\item{edges_prune_percentage}{How many percentage of edges should be pruned. Default is \code{0.5}}

\item{options}{The Shiny server options, such as binding address or listening port.}
}
\description{
Show the given process map in a Shiny server web application, with ability to adjust the nodes and edges precision in the real time.
}
\examples{
library(pmap)
# Generate a random eventlog
eventlog <- generate_eventlog()
# Create the process map from the event log
p <- create_pmap(eventlog)
# Render process map as Shiny app
# render_pmap_shiny(p)
}
