% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statRes_class.R
\name{statRes_output}
\alias{statRes_output}
\title{Function to take raw output of `imd_anova` and create output for `statRes` object}
\usage{
statRes_output(
  imd_anova_out,
  omicsData,
  comparisons,
  test_method,
  pval_adjust_a_multcomp,
  pval_adjust_g_multcomp,
  pval_adjust_a_fdr,
  pval_adjust_g_fdr,
  pval_thresh
)
}
\arguments{
\item{imd_anova_out}{data frame containing the results of the
\code{imd_anova} call.}

\item{omicsData}{pmartR data object of any class, which has a `group_df`
attribute that is usually created by the `group_designation()` function}

\item{comparisons}{character vector of comparison names, e.g. c("A_vs_B", "B_vs_C", ...)}

\item{test_method}{test method used ("anova", "gtest", or "combined")}

\item{pval_adjust_a_multcomp}{character string specifying which type of multiple
comparison adjustment was implemented for ANOVA tests. Valid options include:
"bonferroni", "holm", "tukey", and "dunnett".}

\item{pval_adjust_g_multcomp}{character string specifying which type of multiple
comparison adjustment was implemented for G-tests. Valid options include:
"bonferroni" and "holm".}

\item{pval_adjust_a_fdr}{character string specifying which type of FDR
adjustment was implemented for ANOVA tests. Valid options include:
"bonferroni", "BH", "BY", and "fdr".}

\item{pval_adjust_g_fdr}{character string specifying which type of FDR
adjustment was implemented for G-tests. Valid options include:
"bonferroni", "BH", "BY", and "fdr".}

\item{pval_thresh}{numeric p-value threshold value}
}
\value{
object of class statRes
}
\description{
Function to take raw output of `imd_anova` and create output for `statRes` object
}
