% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metar_speed.R
\name{metar_speed}
\alias{metar_speed}
\title{Get wind speed}
\usage{
metar_speed(x, metric = TRUE)
}
\arguments{
\item{x}{character vector; METAR weather report or reports.}

\item{metric}{logical; the default value is TRUE and a returned wind speed is in m/s;
if it's FALSE then in knots.}
}
\value{
a numeric vector. A wind speed in m/s or in knots.
}
\description{
Extract a wind speed value from METAR weather report.
}
\examples{
metar_speed("EPWA 281830Z 18009KT 140V200 9999 SCT037 03/M01 Q1008 NOSIG")
metar_speed("CYUL 281800Z 13008KT 30SM BKN240 01/M06 A3005 RMK CI5 SLP180", metric = FALSE)
metar_speed("201711271930 METAR LEMD 271930Z 02002KT CAVOK 04/M03 Q1025 NOSIG= NOSIG=")
metar_speed("EPKK 141730Z VRB01KT CAVOK 21/16 Q1028")

}
