% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/makeOutputNodes.R
\name{makeOutputNodes}
\alias{makeOutputNodes}
\title{Add Output nodes to a PMML object.}
\usage{
makeOutputNodes(name = "OutputField", attributes = NULL,
  expression = NULL, namespace = "4_2")
}
\arguments{
\item{name}{The name of the element to be created}

\item{attributes}{The node attributes to be added}

\item{expression}{Post-processing information to be included in the element.
This expression will be processed by the functionToPMML function}

\item{namespace}{The namespace of the PMML model}
}
\value{
List of nodes
}
\description{
Add Output nodes to a PMML object.
}
\details{
This function will create a list of nodes with names 'name', attributes 'attributes' and
child elements 'expression'. 'expression' is a string converted to XML similar to th
functionToPMML function. Meant to create OutputField elements, 'expressions' allows one
to include post-processing transformations to a model. To create multiple such nodes,
all the parameters must be given as lists of equal length.
}
\examples{
# make 2 nodes, one with attributes
TwoNodes <- makeOutputNodes(name=list("OutputField","OutputField"),
             attributes=list(list(name="dbl",optype="continuous"),NULL),
             expression=list("ln(x)","ln(x/(1-x))"))
}
\author{
Tridivesh Jena
}

