% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.iForest.R
\name{pmml.iForest}
\alias{pmml.iForest}
\title{Generate PMML for an iForest object from the \bold{isofor} package.}
\usage{
\method{pmml}{iForest}(model, model.name = "isolationForest_Model",
  app.name = "R", description = "Isolation Forest", copyright = NULL,
  transforms = NULL, unknownValue = NULL, anomalyThreshold = 0.6,
  parentInvalidValueTreatment = "returnInvalid",
  childInvalidValueTreatment = "asIs", ...)
}
\arguments{
\item{model}{an iForest object from package \bold{isofor}}

\item{model.name}{optional; the model name.}

\item{app.name}{optional; name where the model was created.}

\item{description}{optional; description of the model.}

\item{copyright}{optional; a copyright statement.}

\item{transforms}{optional; any pre-processing information from the pmmlTransformations package.}

\item{unknownValue}{optional; a missing value replacement.}

\item{anomalyThreshold}{double between 0 and 1. Predicted values greater than this are classified as anomalies.}

\item{parentInvalidValueTreatment}{invalid value treatment at the top MiningField level.}

\item{childInvalidValueTreatment}{invalid value treatment at the model segment MiningField level.}

\item{...}{further arguments passed to other methods.}
}
\value{
PMML representation of the \code{iForest} object.
}
\description{
Generate PMML for an iForest object from the \bold{isofor} package.
}
\details{
This function converts the iForest model object to the PMML format. The 
PMML outputs the anomaly score as well as a boolean value indicating whether the 
input is an anomaly or not. This is done by simply comparing the anomaly score with
\code{anomalyThreshold}, a parameter in the \code{pmml} function.
The iForest function automatically adds an extra level to all categorical variables, 
labelled "."; this is kept in the PMML representation even though the use of this extra
factor in the predict function is unclear.
}
\examples{
\dontrun{ 
# Any anomalous data points in the Iris dataset? Hopefully none of the 
# anomaly scores are high!
library(isofor)
# create an isolation forest with 10 trees. Sample 30 data points at a time
# from the iris dataset to fit the trees
mod <- iForest(iris,nt=10,phi=30)
#convert to PMML
pm <- pmml(mod)
}

}
\seealso{
\code{\link[pmml]{pmml}},
\href{https://github.com/Zelazny7/isofor}{isofor package}
}
